require "scripts/style.lua"

-- qv_acceptable is a left over signal from mainloop.

if qv_acceptable then
	if qv_reentry then
		DebugOut( "AVOID QUITVERIFY REENTRY" ); 
	else
		DebugOut( "ENTER QUITVERIFY" ); 
		qv_reentry = true;
	  
		local was_paused = IsPaused();
		if not was_paused then
			EnterPause(true);
		end

		local _title = "quit_app_title";
		local _body = "quit_app_body";
		
		-- if the game is running then quitapp has to say the same things that quitgame does.
		if IsGameRunning() then
			_title = "quit_ingame_title";
			_body = "quit_ingame_body";
		end;
			  
		DisplayDialog
		{
			"scripts/yesno.lua",
			yes = function()
				DebugOut("QUITVERIFY YES WAS SELECTED");
				PostMessage( CreateNamedMessage( kQuitNow, "quit" ) );
			end,
			title = _title,
			body = _body,
			noslide = true,
		};

		qv_reentry = false;
		DebugOut( "EXIT QUITVERIFY" ); 
		
		if not was_paused then
			ExitPause();
		end;
	end;
else
	DebugOut( "QUITVERIFY can't run until flash is done" ); 
end;

